<%@ Page Title="Lab Kit Order" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="LabKitOrder.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.LabKitOrder" %>

<%@ Register src="~/Controls/Custom/EFR/FromToDate.ascx" tagname="FromToDate" tagprefix="UserControlFromToDate" %>

    <asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
        <style type="text/css">
            .style1
            {
                width: 100%;
            }
            .style2
            {
                width: 205px;
                margin-left: 120px;
            }
            .style3
            {
                width: 205px;
                margin-left: 120px;
                height: 6px;
            }
            .style4
            {
                height: 6px;
            }
        </style>

    </asp:Content>
    <asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <script type = "text/javascript">

    $(document).ready(function() {
        $('span.invisibleAccess').each(function() {
            var l = $("<label class='invisibleAccess' />")
           .html($(this).html())
            .attr('for', $(this).closest('td').find(':input').attr('id'));
            $(this).replaceWith(l);
        });

        $('label.invisibleAccess').css({ "width": "0", "height": "0", "overflow": "hidden", "position": "absolute" });

        $('.useStockCheck input:checkbox').click(function () {
            if ($(this).is(':checked')) {
                $(this).closest('tr').find(".orderKitCheck input:checkbox").prop("checked", false);
            }
        });

        $('.orderKitCheck input:checkbox').click(function() {
            if ($(this).is(':checked')) {
                $(this).closest('tr').find(".useStockCheck input:checkbox").prop("checked", false);
            }
        });

        $('.checkAllUseStock input:checkbox').click(function() {
            if ($(this).is(':checked')) {
                $(this).closest('table').find(".useStockCheck input:checkbox").prop("checked", true);
                $(this).closest('table').find(".orderKitCheck input:checkbox").prop("checked", false);
            }
            else {
                $(this).closest('table').find(".useStockCheck input:checkbox").prop("checked", false);
            }
        });

    });
    </script>

    <asp:ValidationSummary 
        ID="ValidationSummaryLabKitOrder" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"  
        DisplayMode="BulletList" ShowSummary="false"  ValidationGroup="LabKitOrderSave" ShowMessageBox="True" />

        <fieldset style="border-style:groove; width:100%">
        <table cellspacing="4" width="1200px">
            <tr>
                <td nowrap="nowrap" width="100px">
                    <asp:Label ID="lblInstName1" runat="server" Text="Institution: " AssociatedControlID="lblInstName" SkinID = "DataLabel" ></asp:Label>
                </td>
                <td>
                    <asp:Label runat="server" ID="lblInstName" Height="20px" SkinID = "DataLabel" ></asp:Label></td>
                    <td>&nbsp;</td>
                <td width="80px">
                    <asp:Label ID="Label1" runat="server" Text="Kit Type:" AssociatedControlID="lblKitType" SkinID = "DataLabel" ></asp:Label>
                </td>
                
                <td>
                    <asp:Label runat="server" ID="lblKitType" Height="20px" SkinID = "DataLabel" ></asp:Label></td>
                <td>&nbsp;</td>
                <td>
                    <asp:Label ID="Label2" runat="server" Text="Kit Order Type:" Visible="false" AssociatedControlID="lblOrderType" SkinID = "DataLabel" ></asp:Label>
                </td>
                <td>
                    <asp:Label runat="server" ID="lblOrderType" Height="20px" Visible="false" SkinID = "DataLabel" ></asp:Label></td>
            </tr>
        </table>
        </fieldset>

        <table width="80%">
            <tr>
                <td style="width:80%">
                    <asp:GridView ID="GridViewLabKits" runat="server" 
                    AutoGenerateColumns="False" 
                        Width="80%" 
                        DataKeyNames="WkfCaseId" 
                        EmptyDataText="No patients found for the lab kits." AllowPaging="true" 
                        AllowSorting="true" onsorting="GridViewLabKits_Sorting" ShowFooter = "true" 
                        DataSourceID="ObjectDataSourceLabKits" onrowdatabound="GridView1_RowDataBound"
                        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
                        <Columns>
                            <asp:TemplateField HeaderText="Site Contacted">
                                <ItemTemplate>                                   
                                    <asp:CheckBox ID="chkUseStock" runat="server" 
                                        Width="40px" class = "useStockCheck" />
                                </ItemTemplate>
                                <FooterTemplate>                                                                                            
                                    <asp:CheckBox ID="chkUseAllStock" runat="server" 
                                        Width="40px" class = "checkAllUseStock" />
                                        <br />
                                    <asp:Label ID = "chkUseAllStockLabel" runat = "server" 
                                        Text = "Check All" SkinID = "DataLabel" ></asp:Label>   
                                </FooterTemplate> 
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Contacted By Site">
                                <ItemTemplate>
                                    <asp:CheckBox ID="chkPatId" runat="server" 
                                        Width="40px" class = "orderKitCheck" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText = "Workflow ID">
                                <ItemTemplate>                                    
                                    <asp:Label ID = "lblCaseId" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("WkfCaseId"))) %>' Width="90px" SkinID = "DataLabel"></asp:Label>                                 
                                </ItemTemplate>                                                           
                            </asp:TemplateField> 
                            <asp:TemplateField HeaderText="Patient">                            
                                <ItemTemplate>
                                    <asp:Label ID="lblPatient" runat="server" 
                                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientName"))) %>' Width="140px" SkinID = "DataLabel"></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Date Contacted (mm/dd/yyyy)">
                                <ItemTemplate>                                        
                                    <UserControlFromToDate:FromToDate ID="OrderDate" runat="server" 
                                        ToDate="true" 
                                        DateValue='<%# Bind("KitOrderedDate", "{0:MM/dd/yyyy}") %>'  
                                        StartTabIndex="10" 
                                        ValidationGroup="LabKitOrderSave" 
                                        ErrorMessage="Invalid Date"/>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="VAMC Contact" SortExpression="VAMCContactNm">
                                <ItemTemplate>                                   
                                    <asp:TextBox ID="txtVAMCContact" runat="server" 
                                        MaxLength="255"
                                        Text='<%# Bind("VAMCContactNm") %>' Width="100px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="VAMC Contact Ph#">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtVAMCContactPh" runat="server" 
                                        MaxLength="255"
                                        Text='<%# Bind("VAMCContactPh") %>' 
                                        Width="100px">
                                    </asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Address Line 1">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtAddressLine1" runat="server" MaxLength="100"
                                        Text='<%# Bind("AddressLine1") %>' Width="140px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Address Line 2">
                                <ItemTemplate>                              
                                    <asp:TextBox ID="txtAddressLine2" runat="server" MaxLength="100"
                                        Text='<%# Bind("AddressLine2") %>' Width="140px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Address Line 3">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtAddressLine3" runat="server" MaxLength="100"
                                        Text='<%# Bind("AddressLine3") %>' Width="100px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="City">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtCity" runat="server" Text='<%# Bind("City") %>' MaxLength="60"
                                        Width="80px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="State">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtState" runat="server" Text='<%# Bind("State") %>' MaxLength="50"
                                        Width="80px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Zip">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtPostalCode" runat="server" MaxLength="20"
                                        Text='<%# Bind("PostalCode") %>' Width="35px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="+4">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtZip" runat="server" Text='<%# Bind("ZipPlus4") %>' MaxLength="6" 
                                        Width="30px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>

                            <asp:TemplateField HeaderText="Country">
                                <ItemTemplate>
                                    <asp:TextBox ID="txtCountry" runat="server" Text='<%# Bind("Country") %>' MaxLength="50"
                                        Width="50px"></asp:TextBox>
                                </ItemTemplate>
                            </asp:TemplateField>

                        </Columns>
                    </asp:GridView>
                    
                </td>
            </tr>
            <tr><td> &nbsp;</td></tr>
            <tr>
                <td align="left">
                    <asp:Button ID="btnSave" runat="server" 
                        Text="Save"
                        Width="100px" 
                        ValidationGroup="LabKitOrderSave"
                        onclick="BtnSave_Click" />
                    &nbsp;
                    <asp:Button ID="btnCancel"
                        Width="100px"
                        runat="server" Text="Back" onclick="BtnCancel_Click" UseSubmitBehavior = "false" CssClass = "cancel" />
                    <asp:ObjectDataSource ID="ObjectDataSourceLabKits" runat="server" 
                        OnSelecting="Ds_Selecting"
                        onselected="ObjectDataSourceLabKits_Selected" 
                        SelectMethod="GetNewLabKitOrders" 
                        TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager"
                        SortParameterName="sort"
                        StartRowIndexParameterName="startRow" 
                        MaximumRowsParameterName="maxRows" 
                        SelectCountMethod="GetNewLabKitOrdersCount"
                        EnablePaging="true">
                        <SelectParameters>
                            <asp:QueryStringParameter Name="instId" QueryStringField="InstitutionId" 
                                Type="Int32" />
                            <asp:QueryStringParameter Name="kitTypeId" QueryStringField="KitTypeId" 
                                Type="Int32" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                </td>
            </tr>
        </table>

    </asp:Content>

